/*
 * Decompiled with CFR 0.152.
 */
package com.renyigesai.immortalers_delight.entities.projectile;

import com.renyigesai.immortalers_delight.init.ImmortalersDelightEntities;
import com.renyigesai.immortalers_delight.potion.immortaleffects.StunEffect;
import com.renyigesai.immortalers_delight.util.DifficultyModeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class KiBlastEntity
extends AbstractHurtingProjectile {
    private static final EntityDataAccessor<Boolean> DATA_DANGEROUS = SynchedEntityData.m_135353_(KiBlastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public KiBlastEntity(EntityType<? extends KiBlastEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public KiBlastEntity(Level pLevel, LivingEntity pShooter, double pOffsetX, double pOffsetY, double pOffsetZ) {
        super((EntityType)ImmortalersDelightEntities.KI_BLAST.get(), pShooter, pOffsetX, pOffsetY, pOffsetZ, pLevel);
    }

    @NotNull
    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_175826_;
    }

    protected float m_6884_() {
        return 0.96f;
    }

    public boolean m_6060_() {
        return false;
    }

    public float m_7077_(Explosion pExplosion, BlockGetter pLevel, BlockPos pPos, BlockState pBlockState, FluidState pFluidState, float pExplosionPower) {
        return this.isDangerous() && pBlockState.canEntityDestroy(pLevel, pPos, (Entity)this) ? pExplosionPower : 50.0f;
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.m_9236_().f_46443_) {
            boolean isHurtSuccess;
            Entity hitEntity = pResult.m_82443_();
            Entity ownerEntity = this.m_19749_();
            if (ownerEntity instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)ownerEntity;
                float damage = (float)livingOwner.m_21133_(Attributes.f_22281_);
                damage = Math.min(damage, 5.0f) * 1.3f;
                if (this.isDangerous()) {
                    damage *= 1.7f;
                }
                if ((isHurtSuccess = hitEntity.m_6469_(this.m_269291_().m_269036_((Entity)this, (Entity)livingOwner), damage)) && hitEntity.m_6084_()) {
                    this.m_19970_(livingOwner, hitEntity);
                }
            } else {
                isHurtSuccess = hitEntity.m_6469_(this.m_269291_().m_269425_(), 8.0f);
            }
            if (isHurtSuccess && hitEntity instanceof LivingEntity) {
                LivingEntity livingHitEntity = (LivingEntity)hitEntity;
                int duration = DifficultyModeUtil.isPowerBattleMode() ? 40 : 10;
                double knockbackResistance = livingHitEntity.m_21133_(Attributes.f_22278_);
                if ((duration = (int)((double)duration * (1.0 - knockbackResistance))) > 0) {
                    StunEffect.applyImmortalEffect(livingHitEntity, duration, 0);
                }
            }
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_255391_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1.0f, false, Level.ExplosionInteraction.MOB);
            this.m_146870_();
        }
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        return false;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_DANGEROUS, (Object)false);
    }

    public boolean isDangerous() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DANGEROUS);
    }

    public void setDangerous(boolean pInvulnerable) {
        this.f_19804_.m_135381_(DATA_DANGEROUS, (Object)pInvulnerable);
    }

    protected boolean m_5931_() {
        return false;
    }
}

